function [V,detected_BD_idx] = SE_LWLS(Y,V,I,idx_V,idx_I,sd_V,sd_I,Bad_Data)
% V = SE_LWLS(Y,V,I,idx_V,idx_I,sd_V,sd_I)
% 
% INPUT
% - Y       Nodal admittance matrix.
% - V       Measured voltage phasors.
% - I       Measured current phasors.
% - idx_V   Locations of the voltage phasor measurements.
% - idx_I   Locations of the current phasor measurements.
% - sd_V    Standard deviation of voltage measurement noise.
% - sd_I    Standard deviation of current measurement noise.
% 
% OUTPUT
% - V       Estimated voltage phasors.

z = [real(V);imag(V);real(I);imag(I)];

H = h_LWLS(Y,idx_V,idx_I);
R = R_LWLS(idx_V,idx_I,sd_V,sd_I);

% ******************************
% ! Write your own code here !
% ******************************

x = [];

% ******************************

% Bad data detection
if Bad_Data
    detected_BD_idx = detect_bad_data(z,x,H,R,G);
else
    detected_BD_idx = 0;
end

V = complex(x(1:end/2),x((end/2+1):end));

end
